<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits II Deluxe 2.1.0 - `credits.php`						   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: Darkwaltz4 {blackwaltz4@msn.com}						   # ||
|| # Copyright © 2009 - 2012 John Jakubowski. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #			 Support: http://www.dragonbyte-tech.com/			   # ||
|| ##################################################################### ||
\*=======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE & ~8192);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'credits');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('credits');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	//'credits',
	'credits_home',
	//'credits_transfer',
	'credits_richest',
	'credits_richest_user',
	'credits_transaction'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/class_bbcode.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if ($_REQUEST['do'] == 'devinfo' AND $_REQUEST['devkey'] == 'dbtech') exit('{"version":"2.1.0","pro":"0","vbversion":"' . $vbulletin->versionnumber . '"}');

if (!class_exists('VBCREDITS') OR !$vbulletin->userinfo['userid']) print_no_permission();
$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());//logged in / enabled

if ($_POST['do'] == 'popup')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'target_user'		=> TYPE_STR,
		'target_currency'	=> TYPE_UINT,
		'actionid'			=> TYPE_NOHTML,
		'transfer_currency'	=> TYPE_UINT,
		'adjust_method'		=> TYPE_INT,//1 or -1
		'value'				=> TYPE_STR,//code or num
		'note'				=> TYPE_STR,
		'info'				=> TYPE_BOOL
	));

	if (!$user = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username LIKE '" . $db->escape_string_like(htmlspecialchars_uni(convert_urlencoded_unicode($vbulletin->GPC['target_user']))) . "'")) eval(standard_error(fetch_error('invalid_user_specified')));
	$tarcur =& $vbulletin->vbcredits['currency'][$vbulletin->GPC['target_currency']];
	$usernote = ( $vbulletin->GPC['note'] ? ': ' . $vbulletin->GPC['note'] : '' );
	$user = fetch_userinfo($user['userid']);
	cache_permissions($user, false);
	$good = false;

	switch ($vbulletin->GPC['actionid'])
	{
		case 'transfer':
			$vbulletin->GPC['value'] = floatval($vbulletin->GPC['value']);
			if ($vbulletin->GPC['value'] <= 0) eval(standard_error(fetch_error('credits_transfer_value')));
			$soucur =& $vbulletin->vbcredits['currency'][$vbulletin->GPC['transfer_currency']];
			$action = ( ($transfer = ($user['userid'] == $vbulletin->userinfo['userid'])) ? 'transfer' : 'donate' );
			if ($transfer AND $soucur['currencyid'] == $tarcur['currencyid']) eval(standard_error(fetch_error('credits_transfer_self')));
			$fromself = VBCREDITS::action($action, $vbulletin->userinfo['userid'], true, false, array('currencyid' => $soucur['currencyid'], 'multiplier' => -1 * $vbulletin->GPC['value'], 'message' => $user['username'] . $usernote));

			if (is_numeric($fromself))
			{	//only give if sent worked
				$fromuser = VBCREDITS::action($action, $user['userid'], true, false, array('currencyid' => $tarcur['currencyid'], 'userinfo' => ( $transfer ? null : $user ), 'multiplier' => -1 * $multiplier, 'message' => $vbulletin->userinfo['username'] . $usernote));

				if (is_numeric($fromself))
				{	//only take if give worked
					VBCREDITS::apply($fromself, ( $transfer ? null : $user['userid']));
					VBCREDITS::apply($fromuser, ( $transfer ? null : $vbulletin->userinfo['userid'] ));
					$good = true;
				}
			}

			echo ( $good ? $vbphrase['credits_transfer_success'] : $vbphrase['credits_transfer_failure'] );
		break;
		case 'adjust':
			if ($permissions['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_adjust'])
			{
				$vbulletin->GPC['value'] = floatval($vbulletin->GPC['value']);
				if ($vbulletin->GPC['value'] <= 0) eval(standard_error(fetch_error('credits_transfer_value')));
				VBCREDITS::action('adjust', $user['userid'], $vbulletin->userinfo['userid'], $negate = ($vbulletin->GPC['adjust_method'] < 0), array('currencyid' => $tarcur['currencyid'], 'userinfo' => ( ($user['userid'] != $vbulletin->userinfo['userid']) ? $user : null ), 'multiplier' => ( $negate ? -1 : 1 ) * $vbulletin->GPC['value'], 'ownerid' => $vbulletin->userinfo['userid'], 'message' => $vbulletin->userinfo['username'] . $usernote));
				echo $vbphrase['credits_adjust_success'];
			}
		break;
		//default case with hook?
	}

	if (!$flooding = $db->query_first("SELECT transactionid FROM " . TABLE_PREFIX . "credits_transaction WHERE " . credits_events($vbulletin->GPC['actionid']) . " AND userid = " . $vbulletin->userinfo['userid'] . " AND timestamp >= " . (TIMENOW - 5) . " LIMIT 1")) VBCREDITS::shutdown();
	exit;
}
else
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid'		=> TYPE_UINT,
		'pagenumber'     => TYPE_UINT,
		'currencyid'     => TYPE_UINT,
		'actionid'     => TYPE_NOHTML
	));

	$curs = $acts = array();
	VBCREDITS::display('credits', $vbulletin->userinfo, $template_hook);
	$navbits = array('credits.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['currency']);
	$special = ($permissions['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_special']);
	if ($vbulletin->GPC['userid'] != $vbulletin->userinfo['userid'] AND !($permissions['creditspermissions'] & $vbulletin->bf_ugp_creditspermissions['credits_viewlog'])) $vbulletin->GPC['userid'] = $vbulletin->userinfo['userid'];

	if ($vbulletin->GPC['userid'])
	{	//look up specific user
		if ($notmyself = ($vbulletin->userinfo['userid'] != $vbulletin->GPC['userid']))
		{
			$userinfo = fetch_userinfo($vbulletin->GPC['userid']);
			cache_permissions($userinfo, false);
		}	//myself should be up to date
		else $userinfo =& $vbulletin->userinfo;
	}
	if (is_array($vbulletin->vbcredits['currency']) AND $vbulletin->options['credits_richest'])
	{
		foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
		{
			if ($currency['privacy'] == 2 OR $special)
			{	//public currencies or im special
				$hook_query_fields = $hook_query_joins = $topusers = '';
				VBCREDITS::user($hook_query_fields, $hook_query_joins);
				$users = $db->query_read("SELECT userfield.*, usertextfield.*, user.*, IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid" .
				$hook_query_fields . " FROM " . TABLE_PREFIX . "user AS user LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid)
				LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " . $hook_query_joins . "
				ORDER BY vbcredits_$currencyid DESC LIMIT " . $vbulletin->options['credits_richest']);

				while ($user = $db->fetch_array($users))
				{
					$useramt =& $user['vbcredits_' . $currencyid];
					if ($useramt < 0 AND $currency['negative'] == 1) $useramt = 0;
					$useramt = fetch_word_wrapped_string(vb_number_format($useramt, $currency['decimals']));
					$user['musername'] = fetch_musername($user);

					if ($vb4)
					{
						$t = vB_Template::create('credits_richest_user');
						$t->register('currencyid', $currencyid);
						$t->register('useramt', $useramt);
						$t->register('user', $user);
						$t->register('vb4', $vb4);
						$topusers .= $t->render();
					}
					else eval('$topusers .= "' . fetch_template('credits_richest_user') . '";');
				}

				$db->free_result($users);

				if ($vb4)
				{
					$t = vB_Template::create('credits_richest');
					$t->register('currency', $currency);
					$t->register('topusers', $topusers);
					$t->register('vb4', $vb4);
					$richest .= $t->render();
				}
				else eval('$richest .= "' . fetch_template('credits_richest') . '";');
			}

			$curs[$currencyid] = $currency['title'];//for the dropdown
		}
	}

	foreach ($vbulletin->vbcredits['action'] AS $actionid => $action) $acts[$vbphrase['credits_category_' . $action['category']]][$actionid] = $action['title'];
	$allcurrencies = construct_select_options($curs, $vbulletin->GPC['currencyid']);
	$allactions = construct_select_options($acts, $vbulletin->GPC['actionid']);

	$condition = 'status = 1' . ( $userinfo['userid'] ? ' AND userid = ' . $userinfo['userid'] : '' );
	if ($vbulletin->GPC['actionid'] OR $vbulletin->GPC['currencyid']) $condition .= ' AND ' . credits_events($vbulletin->GPC['actionid'], $vbulletin->GPC['currencyid']);
	$counttrans = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "credits_transaction WHERE $condition");
	if ($vbulletin->GPC['pagenumber'] < 1) $vbulletin->GPC['pagenumber'] = 1;

	$perpage = $vbulletin->options['credits_transactions'];
	$total_pages = max(ceil($counttrans['total'] / $perpage), 1);
	$pagenumber = ($vbulletin->GPC['pagenumber'] > $total_pages ? $total_pages : $vbulletin->GPC['pagenumber']);
	$start = ($pagenumber - 1) * $perpage;

	$sizetext = 'credits_size_' . ( $vbulletin->options['credits_size_words'] ? 'word' : 'char' );
	$sizetext = array($vbphrase[$sizetext . 's'], $vbphrase[$sizetext]);//size mult labels
	$pagenav = construct_page_nav($pagenumber, $perpage, $counttrans['total'], 'credits.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $vbulletin->GPC['userid'] . '&currencyid=' . $vbulletin->GPC['currencyid'] . '&actionid=' . $vbulletin->GPC['actionid']);

	$entries = $userids = $names = array(); $transactions = '';
	$trans = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_transaction WHERE $condition ORDER BY timestamp DESC LIMIT $start, $perpage");

	while ($tran = $db->fetch_array($trans))
	{	//pick out userids
		$entries[] = $tran;
		$userids[] = $tran['userid'];
	}
	if ($userids = array_unique($userids))
	{	//transactions found with users
		$db->free_result($trans);
		$users = $db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(',', $userids) . ")");
		while ($user = $db->fetch_array($users)) $names[$user['userid']] = $user['username'];
		$db->free_result($users);
	}
	foreach ($entries AS $tran)
	{
		$which = 'earned';
		$tran['username'] = $names[$tran['userid']];
		$action =& $vbulletin->vbcredits['action'][$tran['actionid']];
		$negate = ( $tran['negate'] ? array('<i>', '</i>', '<s>', '</s>') : array('', '', '', '') );
		$multlabel = ( ($action['multiplier'] == 'Size') ? $sizetext : ( $action['currency'] ? $vbphrase['currency'] : explode('|', $action['multiplier'], 2) ) );
		$mult = ( $action['multiplier'] ? array('<span title="' . $multlabel[0] . ': ' . $tran['multiplier'] . '">', '</span>') : array('', '') );
		$currency =& $vbulletin->vbcredits['currency'][$tran['currencyid']];
		$f = ( $userinfo['userid'] ? 5 : 0 );//for vb3 widths

		if ($tran['amount'] < 0)
		{
			$which = 'spent';
			$tran['amount'] *= -1;
		}

		$transdate = vbdate($vbulletin->options['dateformat'], $tran['timestamp'], true) . ', ' . vbdate($vbulletin->options['timeformat'], $tran['timestamp']);
		$tranaction = $negate[2] . $action['title'] . $negate[3];
		$trannote = $bbcode_parser->parse($tran['message']);
		$tranamount = $negate[0] . $mult[0] . construct_phrase($vbphrase['credits_transaction_' . $which], vb_number_format($tran['amount'], max($currency['decimals'], $vbulletin->options['credits_transaction_decimals'])), $currency['title']) . $mult[1] . $negate[1];
		$tranlink = ( ($action['referformat'] AND $tran['referenceid']) ? $action['referformat'] . $tran['referenceid'] : '' );

		if ($vb4)
		{
			$t = vB_Template::create('credits_transaction');
			$t->register('userinfo', $userinfo);
			$t->register('transdate', $transdate);
			$t->register('tranaction', $tranaction);
			$t->register('tranamount', $tranamount);
			$t->register('tranlink', $tranlink);
			$t->register('trannote', $trannote);
			$t->register('tran', $tran);
			$t->register('vb4', $vb4);
			$transactions .= $t->render();
		}
		else eval('$transactions .= "' . fetch_template('credits_transaction') . '";');
	}
	//	if (!$numtrans)
	//	{
	//		print_description_row('No Transactions Found', false, 7, '', 'center');
	//	}

	if ($vb4)
	{
		$navbar = render_navbar_template(construct_navbits($navbits));
		$t = vB_Template::create('credits_home');
		$t->register_page_templates();
		$t->register('richest', 			$richest);
		$t->register('transactions',		$transactions);
		$t->register('allcurrencies',		$allcurrencies);
		$t->register('allactions',		$allactions);
		$t->register('pagenav',		$pagenav);
		$t->register('navbar', 				$navbar);
		$t->register('pagetitle', 			$pagetitle);
		$t->register('pagedescription', 	$pagedescription);
		$t->register('template_hook', 		$template_hook);
		$t->register('includecss', 			$includecss);
		$t->register('vb4', 			$vb4);
		$t->register('userinfo', $userinfo);
		print_output($t->render());
	}
	else
	{
		// Create navbits
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		eval('print_output("' . fetch_template('credits_home') . '");');
	}
}
?>
